---
generated_at: 2026-01-22 11:05:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：48-Pydantic v2互換

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **ModelFieldのvalidate/serialize**：詳細なパラメータ仕様確認
  2. **get_definitions関数**：複雑な処理のため詳細確認推奨
  3. **パフォーマンス要件**：キャッシュ動作の詳細確認

## 2) 参照した情報（Evidence一覧）

- E-01: `fastapi/_compat/__init__.py` 1-42行目
- E-02: `fastapi/_compat/shared.py` 1-207行目
- E-03: `fastapi/_compat/v2.py` 1-569行目
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` 49行目
- E-05: Pydantic v2公式ドキュメント

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Pydantic v2との互換性レイヤーを提供 | E-04（"Pydantic v2との互換性レイヤー"） | ○ |
| C-02 | モデルフィールド、バリデーション、シリアライゼーションの統合 | E-04（"モデルフィールド、バリデーション、シリアライゼーションの統合"） | ○ |
| C-03 | _compatディレクトリは3ファイルで構成 | E-01, E-02, E-03（__init__.py、shared.py、v2.py） | ○ |
| C-04 | ModelFieldはデータクラスとして実装 | E-03（98行目: `@dataclass class ModelField:`） | ○ |
| C-05 | lenient_issubclassは型エラーを無視 | E-02（49-57行目） | ○ |
| C-06 | PYDANTIC_V2フラグでバージョン判定 | E-02（31行目: `PYDANTIC_V2 = PYDANTIC_VERSION_MINOR_TUPLE[0] == 2`） | ○ |
| C-07 | annotation_is_pydantic_v1でv1モデル判定 | E-02（194-206行目） | ○ |
| C-08 | PydanticV1NotSupportedErrorが発生する | E-03（v2.pyからのインポート、utils.pyでの使用） | ○ |
| C-09 | TypeAdapterを使用してバリデーション | E-03（156行目: `self._type_adapter: TypeAdapter[Any]`） | ○ |
| C-10 | get_cached_model_fieldsはlru_cacheでキャッシュ | E-03（478行目: `@lru_cache`） | ○ |
| C-11 | Undefinedは PydanticUndefinedにマップ | E-03（45行目: `Undefined = PydanticUndefined`） | ○ |
| C-12 | BaseConfigは空クラスとして定義 | E-03（90-91行目: `class BaseConfig: pass`） | ○ |
| C-13 | Pydantic 2.12以降の警告を抑制 | E-03（140-144行目: `UnsupportedFieldAttributeWarning`） | ○ |
| C-14 | get_definitions関数でJSON Schema生成 | E-03（252-313行目） | ○ |
| C-15 | create_body_model関数でBodyモデル作成 | E-03（452-458行目） | ○ |
| C-16 | WeakKeyDictionaryでメモリリーク防止 | **根拠なし（utils.pyの_CLONED_TYPES_CACHEだが_compatでの直接使用未確認）** | △ |

## 4) 不足情報（Unknown / Missing）

- WeakKeyDictionaryの_compat内での直接使用箇所
  - 候補：utils.pyでの使用確認 / _compatモジュール全体のキャッシュ戦略確認

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - 主要な実装は明確に確認可能
- 0: 低リスク - 機能一覧との整合性確認済み
- 1: 中リスク - Pydanticバージョンアップ時の互換性影響あり

## 6) レビュアーチェックリスト（最小）

- [ ] E-01の__init__.pyが全ての必要な要素をエクスポートしているか確認
- [ ] E-02のshared.pyの型判定関数が正しく動作するか確認
- [ ] E-03のv2.pyのModelFieldクラスが正しくバリデーション/シリアライゼーションを行うか確認
- [ ] Pydantic v2の最新バージョンとの互換性を確認
- [ ] WeakKeyDictionaryの使用箇所と目的を確認
